import { IconType } from "@/types/utils";
import React from "react";

const CompareIcon: IconType = ({ size, ...otherProps }) => (
  <svg
    width={size || "20"}
    height={size || "20"}
    viewBox="0 0 20 20"
    {...otherProps}
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M13.798 16.1943L13.798 2.77143C13.798 2.36 14.1327 2 14.5705 2C14.9826 2 15.3431 2.33429 15.3431 2.77143L15.3431 16.1686C15.3431 16.58 15.0083 16.94 14.5705 16.94C14.1585 16.94 13.798 16.6057 13.798 16.1943Z"
      fill="currentColor"
    />
    <path
      d="M10.1409 6.44857C10.1409 6.24286 10.2182 6.06286 10.3727 5.90857L14.0297 2.23143C14.3387 1.94857 14.8022 1.94857 15.1113 2.23143L18.7682 5.88286C19.0773 6.19143 19.0773 6.65429 18.7682 6.96286C18.4592 7.27143 17.9956 7.27143 17.6866 6.96286L14.5705 3.85143L11.4543 6.98857C11.1453 7.27143 10.6818 7.27143 10.3727 6.98857C10.2182 6.83429 10.1409 6.62857 10.1409 6.44857Z"
      fill="currentColor"
    />
    <path
      d="M4.6555 17.2286L4.6555 3.83149C4.6555 3.42006 4.99029 3.06006 5.42809 3.06006C5.84014 3.06006 6.20068 3.39434 6.20068 3.83149L6.20068 17.2286C6.20068 17.6401 5.86589 18.0001 5.42809 18.0001C4.99029 18.0001 4.6555 17.6658 4.6555 17.2286Z"
      fill="currentColor"
    />
    <path
      d="M0.998605 13.5771C0.998605 13.3714 1.07586 13.1914 1.23038 13.0371C1.53942 12.7542 2.00297 12.7542 2.31201 13.0371L5.42814 16.1742L8.54426 13.0371C8.8533 12.7285 9.31685 12.7285 9.62589 13.0371C9.93493 13.3457 9.93493 13.8085 9.62589 14.1171L5.96895 17.7685C5.65991 18.0514 5.19636 18.0514 4.88732 17.7685L1.20463 14.1171C1.07586 13.9628 0.998605 13.7828 0.998605 13.5771Z"
      fill="currentColor"
    />
  </svg>
);

export default CompareIcon;
